# 機能設計書 52-CGI プロバイダー

## 概要

本ドキュメントは、Horse WebフレームワークにおけるCGI（Common Gateway Interface）プロバイダー機能の設計を記述する。

### 本機能の処理概要

CGI プロバイダーは、Webサーバー（Apache、Nginx等）のCGI機能を通じてHorseアプリケーションを実行するための機能を提供する。CGIモードでは、Webサーバーがリクエストごとにプロセスを起動し、標準入出力を介してHTTPリクエスト・レスポンスを処理する。

**業務上の目的・背景**：共有ホスティング環境など、常駐サーバープロセスを維持できない環境でもHorseアプリケーションを運用する需要がある。CGI プロバイダーにより、従来のCGIモデルに準拠した形でWebアプリケーションをデプロイできる。レガシー環境との互換性やシンプルなデプロイメント要件に対応する。

**機能の利用シーン**：
- 共有ホスティング環境でWebアプリケーションを運用する場合
- 常駐プロセスが許可されていないサーバー環境での運用
- 従来のCGIベースのデプロイメントフローを維持したい場合
- リクエスト量が少なく、プロセス起動オーバーヘッドが許容できる場合

**主要な処理内容**：
1. CGIアプリケーション（Web.CGIApp）の初期化
2. WebModuleClass の設定による THorseWebModule の登録
3. 起動時コールバックの実行
4. Application.Run によるリクエスト処理ループの開始

**関連システム・外部連携**：
- Webサーバー（Apache、Nginx等）のCGI機能
- Delphi WebBroker フレームワーク（Web.CGIApp）
- 標準入出力を介したHTTP通信

**権限による制御**：CGI プロバイダー自体には権限制御機能はなく、WebサーバーのCGI設定とファイルシステム権限に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | Webモジュール | API連携 | CGIモードでHTTPリクエストを処理 |
| 8 | Webモジュール | API連携 | CGIモードでHTTPリクエストを処理（Lazarus版） |

## 機能種別

サーバー管理 / CGI実行基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Callback | TProc | No | 起動時コールバック | - |

### 入力データソース

- Webサーバーからの標準入力（HTTPリクエストボディ）
- 環境変数（HTTPヘッダー、クエリパラメータ等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 標準出力 | Stream | HTTPレスポンス（ヘッダー + ボディ） |

### 出力先

- 標準出力を介したWebサーバーへのレスポンス送信

## 処理フロー

### 処理シーケンス

```
1. Listen メソッド呼び出し
   └─ InternalListen を呼び出す
2. CGIアプリケーション初期化
   └─ Application.Initialize 呼び出し
3. WebModuleClass 設定
   └─ THorseWebModule を Application.WebModuleClass に設定
4. コールバック実行
   └─ DoOnListen で起動時コールバック実行
5. アプリケーション実行
   └─ Application.Run でリクエスト処理開始
```

### フローチャート

```mermaid
flowchart TD
    A[Listen 呼び出し] --> B{コールバックあり?}
    B -->|Yes| C[SetOnListen 設定]
    B -->|No| D[InternalListen 呼び出し]
    C --> D
    D --> E[Application.Initialize]
    E --> F[WebModuleClass = THorseWebModule]
    F --> G[DoOnListen]
    G --> H[Application.Run]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-52-01 | CGI実行モデル | リクエストごとにプロセスが起動・終了 | CGIモード動作時 |
| BR-52-02 | 標準入出力使用 | HTTP通信はstdin/stdoutを介して行われる | CGIモード動作時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | EHorseCallbackInterrupted | コールバックチェーン中断時 | 例外を捕捉して正常終了として扱う |

### リトライ仕様

CGIモデルではリクエストごとにプロセスが起動するため、リトライ機能は実装されていない。

## トランザクション仕様

CGIプロセスとして動作するため、データベーストランザクションは本機能では管理しない。

## パフォーマンス要件

- CGIモデルのため、リクエストごとにプロセス起動オーバーヘッドが発生
- 高負荷環境には不向き
- 低〜中程度のトラフィックに適する

## セキュリティ考慮事項

- WebサーバーのCGI設定に依存
- 実行ファイルの権限設定が重要
- 環境変数を介したパラメータ受け渡しに注意

## 備考

- HORSE_CGI コンパイルディレクティブが定義されている必要がある
- Delphi版とFPC/Lazarus版で実装が異なる
- StopListen機能は提供されない（CGIモデルの特性上）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

CGI プロバイダーはシンプルな構造のため、主に抽象クラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | THorseProviderAbstract クラスの定義 |

**読解のコツ**: CGI プロバイダーは Listen メソッドのみを実装し、StopListen は提供しない。これはCGIモデルがリクエストごとにプロセスを起動・終了する特性に起因する。

#### Step 2: Delphi版CGIプロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.CGI.pas | `src/Horse.Provider.CGI.pas` | THorseProvider クラスの実装（Delphi版） |

**主要処理フロー**:
- **5行目**: `{$IF DEFINED(HORSE_CGI) AND NOT DEFINED(FPC)}` - Delphi専用条件コンパイル
- **28-34行目**: InternalListen - CGIアプリケーション初期化と実行
- **30行目**: Application.Initialize - CGIアプリケーション初期化
- **31行目**: WebModuleClass設定
- **32行目**: DoOnListen - コールバック実行
- **33行目**: Application.Run - リクエスト処理開始

#### Step 3: FPC/Lazarus版CGIプロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.FPC.CGI.pas | `src/Horse.Provider.FPC.CGI.pas` | THorseProvider クラスの実装（FPC版） |

**主要処理フロー**:
- **9行目**: `{$IF DEFINED(HORSE_CGI) AND DEFINED(FPC)}` - FPC専用条件コンパイル
- **13行目**: fpCGI ユニットを使用
- **43-48行目**: GetDefaultCGIApplication - TCGIApplication インスタンス取得
- **60-72行目**: InternalListen - FPC版CGIアプリケーション初期化
- **66行目**: AllowDefaultModule = True
- **67行目**: OnGetModule イベント設定
- **68行目**: LegacyRouting = True
- **74-77行目**: DoGetModule - THorseWebModule を返却

#### Step 4: WebModuleを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.WebModule.pas | `src/Horse.WebModule.pas` | THorseWebModule クラス、リクエスト処理 |

**主要処理フロー**:
- **80-85行目**: DoOnRequest（FPC版）- HandlerAction へ委譲
- **87-110行目**: HandlerAction - リクエスト・レスポンス処理

### プログラム呼び出し階層図

```
THorse (Horse.pas)
    │
    └─ THorseProvider (Horse.Provider.CGI.pas / Horse.Provider.FPC.CGI.pas)
           │
           └─ Listen()
                  └─ InternalListen()
                         │
                         ├─ [Delphi版]
                         │      ├─ Application.Initialize()
                         │      ├─ WebModuleClass := THorseWebModule
                         │      ├─ DoOnListen()
                         │      └─ Application.Run()
                         │
                         └─ [FPC版]
                                ├─ GetDefaultCGIApplication()
                                │      └─ Application (TCGIApplication)
                                ├─ AllowDefaultModule := True
                                ├─ OnGetModule := DoGetModule
                                ├─ LegacyRouting := True
                                ├─ Initialize()
                                ├─ DoOnListen()
                                └─ Run()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Webサーバー            ┌─────────────────────────┐
   │                   │   CGI プロバイダー      │
   ├─ 環境変数 ───────▶│   (プロセス起動)        │
   │   (ヘッダー等)    └───────────┬─────────────┘
   │                               │
   └─ 標準入力 ─────────────────────┼──────────────▶ 標準出力
       (リクエストボディ)          │                 (レスポンス)
                                   ▼
                       ┌─────────────────────────┐
                       │   THorseWebModule       │
                       │ (リクエスト処理委譲)   │
                       └───────────┬─────────────┘
                                   │
                                   ▼
                       ┌─────────────────────────┐
                       │   THorseCore.Routes     │
                       │   (ルーティング実行)    │
                       └─────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.pas | `src/Horse.pas` | ソース | メインユニット、コンパイルディレクティブによるプロバイダー選択 |
| Horse.Provider.CGI.pas | `src/Horse.Provider.CGI.pas` | ソース | CGI プロバイダー実装（Delphi版） |
| Horse.Provider.FPC.CGI.pas | `src/Horse.Provider.FPC.CGI.pas` | ソース | CGI プロバイダー実装（FPC版） |
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | プロバイダー抽象基底クラス |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | WebModuleクラス |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | コア機能（ルーティング等） |
| CGI.dpr | `samples/delphi/cgi/CGI.dpr` | プロジェクト | CGIサンプルプロジェクト（Delphi） |
| CGI.lpr | `samples/lazarus/cgi/CGI.lpr` | プロジェクト | CGIサンプルプロジェクト（Lazarus） |
